/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!********************************************************!*\
  !*** ./resources/js/design_1/panel/events_calendar.js ***!
  \********************************************************/
(function ($) {
  "use strict";

  $(document).ready(function () {
    var $dashboardEventsCalendar = $('#dashboardEventsCalendar');
    if ($dashboardEventsCalendar.length > 0) {
      handleEventsCalendar($dashboardEventsCalendar);
    }
  });
  function handleEventsCalendar($el) {
    $el.pDatepicker({
      inline: true,
      altField: '#inlineEventsCalender',
      initialValue: true,
      calendarType: typeof appLocale !== "undefined" && (appLocale === "fa" || appLocale === "FA") ? 'persian' : 'gregorian',
      initialValueType: true,
      autoClose: true,
      altFormat: 'DD MMMM YY',
      calendar: {
        gregorian: {
          locale: 'en'
        },
        persian: {
          locale: 'fa'
        }
      },
      toolbox: {
        calendarSwitch: {
          enabled: false
        }
      },
      navigator: {
        scroll: {
          enabled: false
        },
        text: {
          btnNextText: '<',
          btnPrevText: ">"
        }
      },
      minDate: new persianDate().subtract('day', 0).valueOf(),
      timePicker: {
        enabled: false
      },
      onSelect: getEventsListsByDate,
      checkDate: function checkDate(unix) {
        setTimeout(function () {
          checkDayHasEvents(unix);
        }, 10);
        return true;
      }
    });
  }
  function getEventsListsByDate(unix) {
    var $listParent = $('.js-day-events-card');
    if ($listParent.length) {
      var loadingHtml = "<div class=\"d-flex-center bg-white rounded-16 py-120 px-32 w-100\">\n                    <img src=\"/assets/design_1/img/loading.svg\" width=\"56\" height=\"56\">\n                </div>";
      $listParent.html(loadingHtml);
      var pDate = new persianDate(unix);
      var timestamp = pDate.startOf('day').unix();
      var dayLabel = pDate.format('dddd');
      var date = pDate.format('YYYY-MM-DD');
      var data = {
        timestamp: unix / 1000
      };
      var path = "/panel/events-calender/get-by-day";
      $.post(path, data, function (result) {
        if (result.code === 200) {
          $listParent.html(result.html);
        }
      });
    }
  }
  function checkDayHasEvents(unix) {
    // $eventsWithTimestamp is defined globally in blade
    if (typeof $eventsWithTimestamp !== "undefined") {
      var unixTimestamp = unix / 1000;
      Object.keys($eventsWithTimestamp).forEach(function (key) {
        var event = $eventsWithTimestamp[key];
        if (event && event.start_day && event.end_day && event.start_day <= unixTimestamp && event.end_day >= unixTimestamp) {
          var $cell = $("td[data-unix=\"".concat(unix, "\"]"));
          if ($cell.length) {
            $cell.addClass('has-event');
          }
        }
      });
    }
  }
  $('body').on('click', '.js-upcoming-event-card', function (e) {
    e.preventDefault();
    var $this = $(this);
    var timestamp = $this.attr('data-day');
    getEventsListsByDate(timestamp * 1000);
  });
})(jQuery);
/******/ })()
;